/*****************************************************************************
 * SCT Application Example for LPC11U6x_E6x
 *
 * Implements a start stop event example for the SCT1
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal      Port          Signal
 * -------------------------------------------------------------------------
 * SCT1_OUT0   P2_16         COUNTER_L_RUN
 * SCT1_OUT1   P2_17         COUNTER_H_RUN
 * SCT1_OUT2   P2_18         STATE_1
 * SCT1_OUT3   P2_19         STATE_2
 * ------------------------------------------------------------------------*/
#include "start_stop.h"


void start_stop_init (void)
{
	Chip_SCT_Init(LPC_SCT1);                			   					// enable the SCT0 clock


	Chip_SCT_SetMatchCountL(LPC_SCT1, SCT_MATCH_0, counterL_stop);			// deactivate_L
	Chip_SCT_SetMatchReloadL(LPC_SCT1, SCT_MATCH_0, counterL_stop);

	Chip_SCT_SetMatchCountH(LPC_SCT1, SCT_MATCH_0, counterL_start);			// activate_L
	Chip_SCT_SetMatchReloadH(LPC_SCT1, SCT_MATCH_0, counterL_start);

	Chip_SCT_SetMatchCountL(LPC_SCT1, SCT_MATCH_1, counterH_start);			// activate_H
	Chip_SCT_SetMatchReloadL(LPC_SCT1, SCT_MATCH_1, counterH_start);

	Chip_SCT_SetMatchCountH(LPC_SCT1, SCT_MATCH_1, counterH_stop);			// deactivate_H
	Chip_SCT_SetMatchReloadH(LPC_SCT1, SCT_MATCH_1, counterH_stop);


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0 , ENABLE_STATE1);				// event 0 happens in state 1
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0		|	// MATCHSEL [3:0]   = related to match 0
                                                                        SCT_HEVENT_L			    |	// HEVENT   [4]     = use L state & match
                                                                        SCT_COMBMODE_MATCH		|	// COMBMODE [13:12] = match AND IO condition
                                                                        SCT_STATELD_1			    |	// STATELD  [14]    = STATEV is loaded into state
                                                                        SCT_STATEEV_0			    ));	// STATEV   [19:15] = new state is 0


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_1 , ENABLE_STATE0);				// event 1 happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_1,  (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH0		|	// MATCHSEL [3:0]   = related to match 0
                                                                          SCT_HEVENT_H			    |	// HEVENT   [4]     = use H state & match
                                                                          SCT_COMBMODE_MATCH		|	// COMBMODE [13:12] = match AND IO condition
                                                                          SCT_STATELD_1			    |	// STATELD  [14]    = STATEV is loaded into state
                                                                          SCT_STATEEV_1			    ));	// STATEV   [19:15] = new state is 1


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_2 , ENABLE_STATE0);				// event 2 happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_2, (CHIP_SCT_EVENTCTRL_T) (   SCT_EVECTRL_MATCH1		|	// MATCHSEL [3:0]   = related to match 1
                                                                          SCT_HEVENT_L			    |	// HEVENT   [4]     = use L state & match
                                                                          SCT_COMBMODE_MATCH		|	// COMBMODE [13:12] = match AND IO condition
                                                                          SCT_STATELD_1			    |	// STATELD  [14]    = STATEV is loaded into state
                                                                          SCT_STATEEV_1			    ));	// STATEV   [19:15] = new state is 1

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_3 , ENABLE_STATE1);				// event 3 happens in state 1
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) (   SCT_EVECTRL_MATCH1		|	// MATCHSEL [3:0]   = related to match 1
                                                                          SCT_HEVENT_H			    |	// HEVENT   [4]     = use H state & match
                                                                          SCT_COMBMODE_MATCH		|	// COMBMODE [13:12] = match AND IO condition
                                                                          SCT_STATELD_1			    |	// STATELD  [14]    = STATEV is loaded into state
                                                                          SCT_STATEEV_0			    ));	// STATEV   [19:15] = new state is 0

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0, (CHIP_SCT_EVENT_T) (SCT_EVT_1 | SCT_EVT_3 ));		// event 1 and 3 set OUTP_0   -> counter L RUN
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, (CHIP_SCT_EVENT_T) (SCT_EVT_0 | SCT_EVT_2 ));	// event 0 and 2 clear OUTP_0

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T) (SCT_EVT_0 | SCT_EVT_2 ));		// event 0 and 2 set OUTP_1   -> counter H RUN
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T) (SCT_EVT_1 | SCT_EVT_3 ));	// event 1 and 3 clear OUTP_1

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_2, SCT_EVT_2 );					// event 2 will set OUTP_2    -> STATE 1
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_2, SCT_EVT_0);				// event 0 will clear OUTP_2

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_3, SCT_EVT_1);					// event 1 will set OUTP_3    -> STATE 2
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_3, SCT_EVT_3);				// event 3 will clear OUTP_3


	Chip_SCT_Output(LPC_SCT1,0x01);           								// OUTP_0 high OUTP_1/2/3 low

    LPC_SCT1->STOP_L     = SCT_EVT_0 | SCT_EVT_2;            				// events 0 and 2 STOP the L counter
    LPC_SCT1->START_L    = SCT_EVT_1 | SCT_EVT_3;            				// events 1 and 3 START the L counter
    LPC_SCT1->LIMIT_L    = SCT_EVT_0 | SCT_EVT_2;            				// events 0 and 2 as L counter limit

    LPC_SCT1->STOP_H     = SCT_EVT_1 | SCT_EVT_3;            				// events 1 and 3 STOP the H counter
    LPC_SCT1->START_H    = SCT_EVT_0 | SCT_EVT_2;            				// events 0 and 2 START the H counter
    LPC_SCT1->LIMIT_H    = SCT_EVT_1 | SCT_EVT_3;            				// events 1 and 3 as H counter limit

    LPC_SCT1->CTRL_U	=			(0  << 0)  |            				// DOWN_L [0]     = L counting down
                            (0  << 1)  |           				 	// STOP_L [1]     = L counter does run
                            (0  << 2)  |            				// HALT_L [2]     = unhalt the L counter
                            (1  << 3)  |            				// CLRT_L [3]     = clear L counter
                            (0  << 4)  |            				// BIDIR_L[4]     = not bidirectional counting
                            (11 << 5)  |            				// PRE_L  [12:5]  = L prescaler = 12
                            (0  << 16) |            				// DOWN_H [16]    = H counting down
                            (1  << 17) |            				// STOP_H [1]     = stop the H counter
                            (0  << 18) |            				// HALT_H [2]     = unhalt the H counter
                            (1  << 19) |            				// CLRT_H [3]     = clear H counter
                            (0  << 20) |            				// BIDIR_H[4]     = not bidirectional counting
                            (11 << 21) ;           					// PRE_H  [28:21] = H prescaler = 12

}




int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();

	Chip_Clock_SetSysClockDiv(4);

	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON

	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 , 0x00000081);				// P2_16 is SCT1_OUT0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,17 , 0x00000081);				// P2_17 is SCT1_OUT1
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,18 , 0x00000081);				// P2_18 is SCT1_OUT2
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,19 , 0x00000081);				// P2_19 is SCT1_OUT3

	start_stop_init();                                   			// Initialize SCT


	while (1)                                              			// loop forever
	{
		__WFI();
	}
}
